# Getting Started with SaaS OS

## What You Get
- Design tokens (Figma + exports)
- Locked UI contracts
- AI-safe component specifications
- Predictable UI behaviour

## What SaaS OS Is
- A contract-first UI system
- A bridge between Figma, engineering, and AI
- A guardrail against UI drift

## What SaaS OS Is Not
- A component library you “customise freely”
- A CSS framework
- A visual-only design kit

## How to Use (TL;DR)
1. Start in Figma (tokens + contracts)
2. Reference contracts from `/docs/engineering/contracts`
3. Generate code using Cursor / AI
4. Reject any code that violates contracts

## Typical Setup
- Frontend: React / Next.js
- Styling: tokens → CSS / Tailwind / CSS-in-JS
- AI: Cursor with contract references

## First Component to Implement
Start with:
- `ui-button`
- `ui-input`
- `ui-modal`

These establish the core patterns used everywhere else.